/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.chaos.metadata.migrate.extraction.model;

import dk.statsbiblioteket.chaos.metadata.migrate.extraction.exception.DOMSMetadataIncompleteDataException;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.MediaClipWav;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.PBCoreProgramMetadata;
import dk.statsbiblioteket.chaos.metadata.migrate.model.BESClippingConfiguration;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioProgram
implements Comparable<RadioProgram> {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public String shardPid;
    public PBCoreProgramMetadata pbcoreProgramMetadata;
    public List<MediaClipWav> subClips = new ArrayList<MediaClipWav>();
    private BESClippingConfiguration besConfiguration;
    private long updatedInDOMSDate;

    private RadioProgram() {
    }

    public RadioProgram(String shardPid) {
        this();
        this.shardPid = shardPid;
    }

    public RadioProgram(String shardPid, BESClippingConfiguration besConfiguration) {
        this(shardPid);
        this.besConfiguration = besConfiguration;
    }

    public RadioProgram(String shardPid, long updatedInDOMSDate) {
        this(shardPid);
        this.updatedInDOMSDate = updatedInDOMSDate;
    }

    public RadioProgram(String shardPid, long updatedInDOMSDate, BESClippingConfiguration besConfiguration) {
        this(shardPid, updatedInDOMSDate);
        this.besConfiguration = besConfiguration;
    }

    public void addRadioClip(MediaClipWav radioClip) {
        this.subClips.add(radioClip);
    }

    public long getUpdatedInDOMSDate() {
        return this.updatedInDOMSDate;
    }

    public PBCoreProgramMetadata getPbcoreProgramMetadata() {
        return this.pbcoreProgramMetadata;
    }

    public void setPbcoreProgramMetadata(PBCoreProgramMetadata pbcoreProgramMetadata) {
        this.pbcoreProgramMetadata = pbcoreProgramMetadata;
    }

    public String getPresentationFilename() {
        return this.shardPid.substring(5, this.shardPid.length()) + ".mp3";
    }

    public long getTotalClipDurationInSeconds() {
        long duration = 0L;
        for (MediaClipWav clip : this.subClips) {
            duration += clip.clipLength;
        }
        return duration += -this.besConfiguration.radioStartOffset + this.besConfiguration.radioEndOffset;
    }

    public Date getClipStartTime() throws DOMSMetadataIncompleteDataException {
        if (this.subClips.isEmpty()) {
            throw new DOMSMetadataIncompleteDataException("Clips expected: " + this.subClips);
        }
        Collections.sort(this.subClips);
        return new Date(this.subClips.get((int)0).clipStart.getTime() + this.besConfiguration.radioStartOffset * 1000L);
    }

    public Date getClipEndTime() throws DOMSMetadataIncompleteDataException {
        if (this.subClips.isEmpty()) {
            throw new DOMSMetadataIncompleteDataException("Clips expected: " + this.subClips);
        }
        Date clipEndTime = new Date(this.getClipStartTime().getTime() + this.getTotalClipDurationInSeconds() * 1000L);
        return clipEndTime;
    }

    public String toString() {
        String s = this.getClass().getSimpleName() + " [uuid : " + this.shardPid + ", pbcoreMetadata : " + this.pbcoreProgramMetadata;
        try {
            s = s + ", clip [" + (this.getClipStartTime() != null ? sdf.format(this.getClipStartTime()) : this.getClipStartTime()) + " : " + (this.getClipEndTime() != null ? sdf.format(this.getClipEndTime()) : this.getClipEndTime()) + "]";
            s = s + ", sub-clips : " + this.subClips;
        }
        catch (DOMSMetadataIncompleteDataException e) {
            s = s + ", clip [no-clip-info]";
        }
        s = s + "]";
        return s;
    }

    @Override
    public int compareTo(RadioProgram other) {
        int result = this.pbcoreProgramMetadata.start == null ? (other.pbcoreProgramMetadata.start == null ? 0 : -1) : (other.pbcoreProgramMetadata.start == null ? 1 : this.pbcoreProgramMetadata.start.compareTo(other.pbcoreProgramMetadata.start));
        return result;
    }
}

