/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.chaos.metadata.migrate.filter;

import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.MediaClipWav;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.RadioProgram;
import dk.statsbiblioteket.chaos.metadata.migrate.extraction.model.RadioProgramSearchResultItem;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterService {
    private static Logger logger = Logger.getLogger(FilterService.class);

    public static List<RadioProgram> filterOutRadioProgramsWithClipFromFileList(List<RadioProgram> radioPrograms, List<String> sourceFilesToFilterOut) {
        ArrayList<RadioProgram> radioProgramsNotFromSourceFiles = new ArrayList<RadioProgram>();
        TreeSet<String> sortedSourceFilenames = new TreeSet<String>(sourceFilesToFilterOut);
        for (RadioProgram radioProgram : radioPrograms) {
            List<String> filterReasons = FilterService.areClipsBasedOnFilterFiles(sortedSourceFilenames, radioProgram);
            if (filterReasons.size() == 0) {
                radioProgramsNotFromSourceFiles.add(radioProgram);
                continue;
            }
            String filterReason = "Clip based on source file to filter out.";
            for (String reason : filterReasons) {
                filterReason = filterReason + " - " + reason;
            }
            logger.info("Filtered out program: " + radioProgram.toString());
            logger.info("Reason: " + filterReason);
        }
        return radioProgramsNotFromSourceFiles;
    }

    public static void filterResult(List<String> sourceFilesToFilterOut, List<RadioProgramSearchResultItem> radioProgramSearchResults) {
        TreeSet<String> sortedSourceFilenames = new TreeSet<String>(sourceFilesToFilterOut);
        for (RadioProgramSearchResultItem radioProgramSearchResult : radioProgramSearchResults) {
            List<String> filterReasons;
            if (!radioProgramSearchResult.isExtractionSuccessful() || (filterReasons = FilterService.areClipsBasedOnFilterFiles(sortedSourceFilenames, radioProgramSearchResult.getRadioProgram())).size() <= 0) continue;
            String filterReason = "Clip based on source file to filter out.";
            for (String reason : filterReasons) {
                filterReason = filterReason + " - " + reason;
            }
            radioProgramSearchResult.filteredOut(filterReason);
            logger.info("Filtered out program: " + radioProgramSearchResult.getRadioProgram());
            logger.info("Reason: " + filterReason);
        }
    }

    private static List<String> areClipsBasedOnFilterFiles(SortedSet<String> sortedSourceFilenames, RadioProgram radioProgram) {
        ArrayList<String> filterReasons = new ArrayList<String>();
        for (MediaClipWav radioClip : radioProgram.subClips) {
            String sourceFilename = radioClip.sourceFilename.replaceAll("_encoder.-.\\.wav", ".mp3");
            if (!sortedSourceFilenames.contains(sourceFilename)) continue;
            filterReasons.add("Clip file: " + radioClip.sourceFilename + " is based on filter file: " + sourceFilename);
        }
        return filterReasons;
    }
}

