/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util;

import dk.statsbiblioteket.util.Logs;
import dk.statsbiblioteket.util.Streams;
import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.IOException;
import java.io.StringWriter;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL, author="te", comment="getCollationKey is poorly implemented due to the CollationKeyclass being final")
public class CachedCollator
extends Collator {
    private static Logger log = Logger.getLogger(CachedCollator.class);
    public static final String COMMON_NON_LETTER = " !\"#$%&'()*+,-./0123456789:;<=>?[\\]^_{|}~@";
    public static final String COMMON_AZ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String COMMON_DK_SPECIFIC = "\u00e6\u00f8\u00e5\u00c6\u00d8\u00c5";
    public static final String COMMON_SUMMA_EXTRACTED = "eaoi 0ntr1s24cl93857hd6pgum.bfv:xwykj_z/-qASPCXIU\u00f8NEG\u00e6$>\u00e9#V\u00e4\u00e5\u00f6&\u00fc^\u00e1\u0101L\u00f3~\u2013\u00ed\u00e3T*@\u0131\u00e7%\u010d\u00e2\u00e8BM|\u0161\u2014FY\u00eaD\u00fa\u00e0\u016b\u017e\u00f1R\u00f0\u00b7O\u0107\u2212\u00f4\u00eb,\u0142\u03b2\u03b1\u00b0\u00b1H\u015f\u012b\u00eeJ\u00f5KZQ\u0113\u015b\u03b4\u2020\u1e63\u014d\u00ef\u011b\u011f\u0103\u0144\u00fd\u0159\u00fb\u0117\u2192\u00ec\u00fe\u00d7\u00b5\u03bc\u03b3\u00a7\u00df\u03bf\u223c\u00a3\u00f2\u0094\u25bf\u01b0\u03ba\u0111\u03c3\u01a1\u03bb\u00f9\u03b5\u03b9\u017c\u03c4\u0119\u00ad\u03bd\u03c0\u0105\u03c1\u0153\u00a4\u0151\u03b7\u01e9\u0138\u00ba\u03c6\u2265\u03c2\u012d\u03c9\u03af\u00b3\u22c5\u2264\u0438\u0169\u0148\u0163\u03b8\u03cc\u221e\u03ae\u2122\u03c5\u017a\u0435\u0430\u03ad\u2026\u00b2\u00aaW\u20ac\u2248\u03c8\u00a2\u043d\u0442\u2022\u2191\u013e\u00be\u03cd\u03c7\u2082\u03ce\u0440\u2030\u0171\u03ac\u00ff\u00b9\u043e\u00bd\u1ebd\u2010\u0173\u03b6\u016f;\u043b'\u2021\u03be\u0129\u221a\u2070\u00bc\ufb01\u011d\u0229\u2190\u0432\u043f\u7684\u016d\u025b\u0441\ue00b\u2208\u232a\u2329=\u0434\u0431\u2033\u00f7\u4e66\u0109\u01e7\u043c\u2211\u0155\u201a\u2083\u2193\u207a\u0437\u0443\u014f\u0165\u044f\u56fe\u266d\u2a7e\u222b\u043a\u2202\u0115\ufb02\u03d5\u010f\u2243\u0447\u2207\u2081\u2a7d\u015d\u2113\u2225\u9986\u0095\u2080\u02c9\u2229\u2261\u2245\u0446\u2237\u01c0\u02dc\u2260\u2227\u0121\u2206\u0444\u4e86 \u0433\u22a5\u0146\u207b\u00ac\u0135\u2194\u1e25\u2084?\u044b\u0445\u1e49\u0439\u2217";
    public static final String CHARSTATS = "charstats.dat";
    private Collator subCollator;
    private final int[] cachedPositions = new int[65535];

    public CachedCollator(Locale locale) {
        log.debug("Creating default character collator for locale '" + locale + "'");
        this.subCollator = Collator.getInstance(locale);
        this.buildCache(this.getBasicChars());
    }

    public CachedCollator(Locale locale, String mostCommon) {
        log.debug("Creating collator for locale '" + locale + "' with most common characters '" + mostCommon + "'");
        this.subCollator = Collator.getInstance(locale);
        this.buildCache(mostCommon);
    }

    public CachedCollator(Locale locale, String mostCommon, boolean spaceFirst) {
        this.subCollator = Collator.getInstance(locale);
        if (spaceFirst) {
            this.subCollator = CachedCollator.fixCollator(this.subCollator, false);
        }
        this.buildCache(mostCommon);
    }

    public CachedCollator(Locale locale, boolean spaceFirst) {
        this.subCollator = Collator.getInstance(locale);
        if (spaceFirst) {
            this.subCollator = CachedCollator.fixCollator(this.subCollator, false);
        }
        this.buildCache(this.getBasicChars());
    }

    public CachedCollator(Collator collator) {
        this.subCollator = collator;
        this.buildCache(this.getBasicChars());
    }

    public CachedCollator(Collator collator, String mostCommon) {
        this.subCollator = collator;
        this.buildCache(mostCommon);
    }

    protected String getBasicChars() {
        log.trace("geBasicChars called");
        try {
            return Streams.getUTF8Resource(CHARSTATS);
        }
        catch (IOException e) {
            log.debug("Could not fetch the resource 'charstats.dat'. Defaulting to 0x20-0xFF");
            int START = 32;
            int END = 255;
            StringWriter sw = new StringWriter(END - START + 1);
            for (int i = START; i <= END; ++i) {
                sw.append((char)i);
            }
            return sw.toString();
        }
    }

    protected void buildCache(String mostCommon) {
        log.debug("Building cache for '" + mostCommon + "'");
        LinkedHashSet<String> unique = new LinkedHashSet<String>(mostCommon.length());
        int highest = 0;
        char[] arr$ = mostCommon.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            unique.add(c.toString());
            highest = Math.max(highest, c.charValue());
        }
        ArrayList sorted = new ArrayList(unique);
        Collections.sort(sorted, this.subCollator);
        if (log.isTraceEnabled()) {
            log.trace("mostCommon sorted: '" + Logs.expand(sorted, 5000) + "'");
        }
        int position = 1;
        char lastChar = '\u0000';
        for (String cString : sorted) {
            if (cString.length() != 1) {
                log.warn("The expected character '" + cString + "' was of length " + cString.length() + ". Skipping");
                continue;
            }
            char c = cString.charAt(0);
            if (lastChar == '\u0000') {
                lastChar = c;
            }
            this.cachedPositions[c] = position++;
            if (this.subCollator.compare(Character.toString(lastChar), Character.toString(c)) != 0) {
                // empty if block
            }
            lastChar = c;
        }
        log.debug("Finished building cache for " + position + " characters (" + (mostCommon.length() - position) + " duplicates removed, " + position + " unique positions) " + "of which the highest was " + highest);
    }

    protected int getPosition(char c) {
        return this.cachedPositions[c];
    }

    @Override
    public int compare(String source, String target) {
        if (source == null) {
            return target == null ? 0 : 1;
        }
        if (target == null) {
            return -1;
        }
        int length = Math.min(source.length(), target.length());
        for (int i = 0; i < length - 1; ++i) {
            try {
                int sPos = this.cachedPositions[source.charAt(i)];
                int tPos = this.cachedPositions[target.charAt(i)];
                if (sPos == 0 || tPos == 0) {
                    return this.subCollator.compare(source, target);
                }
                if (sPos == tPos) continue;
                return source.charAt(i + 1) == ' ' || target.charAt(i + 1) == ' ' ? this.subCollator.compare(source, target) : sPos - tPos;
            }
            catch (IndexOutOfBoundsException e) {
                log.debug(String.format("Got an IndexOutOfBoundsException, which should not be possible as cachedPositions should hold entries for all possible char valued. The length of cachedPositions is %d, source.charAt(%d) == '%s', target.charAt(%d) == '%s'", this.cachedPositions.length, i, Character.valueOf(source.charAt(i)), i, Character.valueOf(source.charAt(i))), e);
                return this.subCollator.compare(source, target);
            }
        }
        return this.subCollator.compare(source, target);
    }

    @Override
    public int compare(Object source, Object target) {
        return this.compare((String)source, (String)target);
    }

    @Override
    public CollationKey getCollationKey(String source) {
        return this.subCollator.getCollationKey(source);
    }

    @Override
    public int hashCode() {
        return this.subCollator.hashCode();
    }

    public String getCachedChars() {
        ArrayList<String> chars = new ArrayList<String>(5000);
        for (int i = 0; i < this.cachedPositions.length; ++i) {
            if (this.cachedPositions[i] <= 0) continue;
            chars.add(Character.toString((char)i));
        }
        Collections.sort(chars, this);
        StringWriter sw = new StringWriter(chars.size());
        for (String c : chars) {
            sw.append(c);
        }
        return sw.toString();
    }

    private static Collator fixCollator(Collator collator, boolean check) {
        if (!(collator instanceof RuleBasedCollator)) {
            log.warn(String.format("fixCollator expected a RuleBasedCollator but got %s. Unable to update Collator", collator.getClass()));
            return collator;
        }
        String rules = ((RuleBasedCollator)collator).getRules();
        if (check && rules.indexOf("<' '<'_'") == -1) {
            log.debug("fixCollator: The received Collator already sorts spaces first");
            return collator;
        }
        try {
            RuleBasedCollator newCollator = new RuleBasedCollator(rules.replace("<'_'", "<' '<'_'"));
            log.trace("Successfully updated Collator to prioritize spaces before other characters");
            return newCollator;
        }
        catch (ParseException e) {
            throw new RuntimeException("ParseException while parsing\n" + rules, e);
        }
    }
}

