/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util;

import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class Streams {
    @Deprecated
    public static void pipeStream(InputStream in, OutputStream out, int bufSize) throws IOException {
        Streams.pipe(in, out, bufSize);
    }

    @Deprecated
    public static void pipeStream(InputStream in, OutputStream out) throws IOException {
        Streams.pipe(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(InputStream in, OutputStream out, int bufSize) throws IOException {
        try {
            int len;
            byte[] buf = new byte[bufSize];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static void pipe(InputStream in, OutputStream out) throws IOException {
        Streams.pipe(in, out, 4096);
    }

    public static String getUTF8Resource(String name) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(name);
        if (url == null) {
            throw new FileNotFoundException("Could not locate '" + name + "' in the class path");
        }
        InputStream in = url.openStream();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(1000);
        Streams.pipeStream(in, bytes);
        return bytes.toString("utf-8");
    }

    public static long readLong(InputStream in) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8);
        for (int i = 0; i < 8; ++i) {
            int value = in.read();
            if (value == -1) {
                throw new EOFException("Attempting to read past EOF");
            }
            bb.put((byte)value);
        }
        return bb.getLong(0);
    }
}

