/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.DomDriver;
import dk.statsbiblioteket.util.InvalidPropertiesException;
import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class XProperties
extends Properties
implements Converter {
    public Log log = LogFactory.getLog(XProperties.class);
    private XStream xstream;
    protected File defaultPath = new File(".");
    protected String resourceName;
    private Pattern intPattern = Pattern.compile("-?[0-9]+");
    private Pattern doublePattern = Pattern.compile("-?[0-9]+\\.[0-9]+");

    public XProperties(XProperties defaults) {
        super(defaults);
        this.xstream = new XStream(new DomDriver());
        this.xstream.alias("entry", XPropertiesEntry.class);
        this.xstream.alias("xproperties", XProperties.class);
        this.xstream.registerConverter(this);
    }

    public XProperties(String resourceName, XProperties defaults) throws InvalidPropertiesException, IOException {
        this(defaults);
        this.load(resourceName, true, false);
        this.fillFromEnvironment();
    }

    public XProperties() {
        this((XProperties)null);
        this.fillFromEnvironment();
    }

    public XProperties(String resourceName) throws InvalidPropertiesException, IOException {
        this(resourceName, null);
    }

    public XProperties(String resourceName, boolean fetchProperties) throws InvalidPropertiesException, IOException {
        this();
        if (fetchProperties) {
            this.load(resourceName, true, false);
        } else {
            this.resourceName = resourceName;
        }
        this.fillFromEnvironment();
    }

    public XProperties(String resource, boolean createNew, boolean failOnNotFound) throws InvalidPropertiesException, IOException {
        if (createNew) {
            this.resourceName = resource;
        } else {
            this.load(resource, !failOnNotFound, false);
        }
        this.fillFromEnvironment();
    }

    public XProperties(boolean override) {
        this((XProperties)null);
        if (override) {
            this.fillFromEnvironment();
        }
    }

    protected void fillFromEnvironment() {
        String HEADER = "XProperty:";
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            assert (entry.getKey() instanceof String);
            assert (entry.getValue() instanceof String);
            String key = (String)entry.getKey();
            if (!key.startsWith(HEADER)) continue;
            this.parseAndPutObject(key.substring(HEADER.length(), key.length()), (String)entry.getValue());
        }
    }

    protected void parseAndPutObject(String key, String value) {
        if (key.contains("/")) {
            XProperties sub;
            this.log.trace("Encountered sub property with key '" + key + "'");
            String[] tokens = key.split("/", 2);
            if (this.contains(tokens[0])) {
                sub = this.getSubProperty(tokens[0]);
            } else {
                sub = new XProperties(false);
                this.put(tokens[0], sub);
            }
            sub.parseAndPutObject(tokens[1], value);
        } else if ("true".equals(value)) {
            this.log.trace("Adding boolean true to properties");
            this.put(key, (Object)true);
        } else if ("false".equals(value)) {
            this.log.trace("Adding boolean false to properties");
            this.put(key, (Object)false);
        } else if (this.intPattern.matcher(value).matches()) {
            this.log.trace("Adding integer '" + value + "' to properties");
            try {
                this.put(key, (Object)Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                this.log.warn("Could not parse the expected integer '" + value + "'. Defaulting to String", e);
                this.put(key, value);
            }
        } else if (this.doublePattern.matcher(value).matches()) {
            this.log.trace("Adding double '" + value + "' to properties");
            try {
                this.put(key, (Object)Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                this.log.warn("Could not parse the expected double '" + value + "'. Defaulting to String", e);
                this.put(key, value);
            }
        } else {
            this.log.trace("Adding String '" + value + "' to properties");
            this.put(key, value);
        }
    }

    public Object getObject(String key) throws NullPointerException {
        Object val = super.get(key);
        if (val == null && this.defaults != null) {
            val = ((XProperties)this.defaults).getObject(key);
        }
        if (val == null) {
            throw new NullPointerException("Could not locate value for '" + key + "'");
        }
        return val;
    }

    @Override
    @Deprecated
    public Object get(Object key) {
        return super.get(key);
    }

    public String getString(String key) {
        return (String)this.getObject(key);
    }

    public int getInteger(String key) {
        return (Integer)this.getObject(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.getObject(key);
    }

    public double getDouble(String key) {
        return (Double)this.getObject(key);
    }

    public char getChar(String key) {
        return ((Character)this.getObject(key)).charValue();
    }

    public XProperties getSubProperty(String key) {
        return (XProperties)this.getObject(key);
    }

    public Object putDefault(String key, Object value) {
        if (this.defaults == null) {
            this.defaults = new XProperties();
        }
        return this.defaults.put(key, value);
    }

    public void populateWithDefaults() {
        if (this.defaults != null) {
            ((XProperties)this.defaults).populateWithDefaults();
            for (Map.Entry<Object, Object> entry : this.defaults.entrySet()) {
                if (this.containsKey(entry.getKey())) continue;
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void list(PrintStream out) {
        try {
            this.store(out, "Current properties");
        }
        catch (IOException e) {
            out.println("Unlistable properties.");
            e.printStackTrace(out);
        }
    }

    @Override
    public void list(PrintWriter out) {
        try {
            this.store(out);
        }
        catch (IOException e) {
            out.println("Unlistable properties.");
            e.printStackTrace(out);
        }
    }

    public XStream getXStream() {
        return this.xstream;
    }

    public File getDefaultPath() {
        return this.defaultPath;
    }

    public synchronized void setDefaultPath(File defaultPath) {
        if (!defaultPath.isDirectory() || !defaultPath.canWrite()) {
            throw new IllegalArgumentException("defaultPath must be an existing writable directory");
        }
        this.defaultPath = defaultPath;
    }

    public synchronized void assignFrom(XProperties properties) {
        this.log.trace("Clearing");
        this.clear();
        this.log.trace("Assigning " + properties.size() + " pairs");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        this.log.trace("Assigning other attributes");
        this.defaultPath = properties.defaultPath;
        this.resourceName = properties.resourceName;
        this.log.trace("Finished assigning");
    }

    public synchronized void load(String resourceName, boolean ignoreNonExisting, boolean ignoreMalformed) throws InvalidPropertiesException, IOException {
        InputStream instream;
        this.log.trace(String.format("Loading resource %s with ignoreNonExisting %s and ignoreMalformed %s", resourceName, ignoreNonExisting, ignoreMalformed));
        this.resourceName = resourceName;
        this.clear();
        this.log.trace("Locating resource '" + resourceName + "'");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resourceURL = loader.getResource(resourceName);
        if (new File(this.defaultPath, resourceName).isFile()) {
            instream = new FileInputStream(new File(this.defaultPath, resourceName));
        } else if (new File(resourceName).isFile()) {
            instream = new FileInputStream(new File(resourceName));
        } else if (resourceURL != null) {
            instream = resourceURL.openStream();
        } else {
            String msg = String.format("Could not locate resource %s", resourceName);
            if (ignoreNonExisting) {
                this.log.debug(msg + ", ignoring");
                return;
            }
            this.log.warn(msg);
            throw new FileNotFoundException(msg);
        }
        this.log.trace("Loading resource");
        if (ignoreMalformed) {
            try {
                this.load(instream);
            }
            catch (InvalidPropertiesException e) {}
        } else {
            this.load(instream);
        }
        this.log.debug(String.format("Properties resource \"%s\" loaded", resourceName));
    }

    @Override
    public void load(InputStream instream) throws IOException {
        InputStreamReader inreader = new InputStreamReader(instream);
        try {
            ObjectInputStream objectIn = this.xstream.createObjectInputStream(inreader);
            Object o = objectIn.readObject();
            XProperties properties = (XProperties)o;
            for (Map.Entry<Object, Object> entries : properties.getEntries()) {
                this.put(entries.getKey(), entries.getValue());
            }
            objectIn.close();
        }
        catch (ClassNotFoundException excl) {
            this.clear();
            String msg = String.format("ClassNotFoundException loading properties from resource %s", this.resourceName);
            this.log.warn(msg);
            throw new InvalidPropertiesException(msg, excl);
        }
        catch (StreamException exst) {
            this.clear();
            String msg = String.format("StreamException loading properties from resource %s", this.resourceName);
            this.log.warn(msg);
            throw new InvalidPropertiesException(msg, exst);
        }
        catch (ClassCastException e) {
            throw new InvalidPropertiesException("Input stream does not look like a valid XProperties file", e);
        }
        finally {
            instream.close();
        }
    }

    @Override
    public void loadFromXML(InputStream instream) throws IOException {
        this.load(instream);
    }

    public void store() throws IOException {
        if (this.resourceName == null) {
            throw new IllegalStateException("No resource name has been set");
        }
        this.store(this.resourceName);
    }

    public synchronized void store(String resourceName) throws IOException {
        this.log.trace(String.format("Storing properties to resource %s", resourceName));
        this.log.trace("Locating resource");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resourceURL = loader.getResource(resourceName);
        File f = new File(this.defaultPath, resourceName).isFile() ? new File(this.defaultPath, resourceName) : (new File(resourceName).isFile() ? new File(resourceName) : (resourceURL != null && new File(resourceURL.getPath()).exists() ? new File(resourceURL.getPath()) : (resourceName.startsWith(File.separator) ? new File(resourceName) : new File(this.defaultPath, resourceName))));
        FileOutputStream filestream = new FileOutputStream(f);
        this.store(filestream, null);
    }

    @Override
    public synchronized void store(OutputStream out, String comments) throws IOException {
        this.store(new PrintWriter(out));
    }

    @Override
    public synchronized void storeToXML(OutputStream out, String comments) throws IOException {
        this.store(new PrintWriter(out));
    }

    @Override
    public synchronized void storeToXML(OutputStream out, String comments, String encoding) throws IOException {
        this.store(new OutputStreamWriter(out, encoding));
    }

    private void store(Writer out) throws IOException {
        this.log.debug("Storing resource");
        ObjectOutputStream objectOut = this.xstream.createObjectOutputStream(out, "xstream");
        objectOut.writeObject(this);
        objectOut.close();
    }

    protected Set<Map.Entry<Object, Object>> getEntries() {
        return this.entrySet();
    }

    @Override
    public boolean canConvert(Class aClass) {
        return XProperties.class.equals((Object)aClass);
    }

    @Override
    public void marshal(Object xpropertiesObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        for (Map.Entry<Object, Object> entry : ((XProperties)xpropertiesObject).getEntries()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            XPropertiesEntry hrentry = new XPropertiesEntry(key, value);
            writer.startNode("entry");
            context.convertAnother(hrentry);
            writer.endNode();
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        XProperties properties = new XProperties();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            XPropertiesEntry entry = (XPropertiesEntry)context.convertAnother(properties, XPropertiesEntry.class);
            reader.moveUp();
            properties.put(entry.key, entry.value);
        }
        return properties;
    }

    private static class XPropertiesEntry {
        String key;
        Object value;

        XPropertiesEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

