/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.qa;

import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.qa.Report;
import dk.statsbiblioteket.util.qa.ReportElement;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL)
public class HTMLReport
implements Report {
    private static final String HEADER_TEMPLATE = "<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n    <title>@TITLE_ESCAPE@</title>\n        <style type=\"text/css\">\n@STYLE_ESCAPE@\n        </style>\n  </head>\n<body>\n<h1>QA Report for @HEADER_ESCAPE@</h1>\n<p><b>Generated: </b><i>@DATE_ESCAPE@</i></p>\n";
    private static final String FOOTER_TEMPLATE = "</body>\n</html>\n";
    private static final String ELEMENT_TEMPLATE = "    <div class=\"element\">\n      <div class=\"element-header\" >\n        <div class=\"element-type\" >@ELEMENT_TYPE_ESCAPE@</div>\n        <div class=\"element-name\" id=\"@ELEMENT_NAME_ESCAPE@\">@ELEMENT_NAME_ESCAPE@</div>\n        @HEADER_INFO_ESCAPE@\n      </div>\n      <div class=\"element-report\">\n        <div class=\"element-qa-level\">\n          <b>QA Level: </b>@QA_LEVEL_ESCAPE@\n        </div>\n        <div class=\"element-qa-state\">\n          <b>QA State: </b>@QA_STATE_ESCAPE@\n        </div>\n        <div class=\"element-file\">\n          @FILE_ESCAPE@\n        </div>\n        @OTHER_INFO_ESCAPE@\n      </div>\n    </div>\n";
    private static final String DEFAULT_STYLE_ESCAPE = ".element {\n        background: #ffffee;\n        padding: 0;\n        margin: 10;\n}\n.element-header {\n        background: #eeeedd;\n        padding: 5;\n}\n.element-type {\n        float: lef;\n        padding-right: 1em;\n}\n.element-name {\n        float: left;\n        padding-right: 2em;}\n.element-report {\n         \n}\n.element-qa-level {\n        \n}\n.element-qa-state {\n        \n}\n.element-filename {\n        \n}\n";
    private String projectName;
    private PrintStream out;
    private boolean initialized;
    private Map<String, ReportElement> parents;
    private List<String> develElements;
    private List<String> undefinedElements;
    private List<String> errorElements;
    private String baseSrcPath;

    public HTMLReport(String projectName, PrintStream out, String baseSrcPath) {
        this.projectName = projectName;
        this.out = out;
        this.initialized = false;
        this.parents = new HashMap<String, ReportElement>();
        this.baseSrcPath = baseSrcPath != null ? baseSrcPath : "";
        this.develElements = new LinkedList<String>();
        this.undefinedElements = new LinkedList<String>();
        this.errorElements = new LinkedList<String>();
    }

    public HTMLReport(String projectName, String baseSrcPath) {
        this(projectName, System.out, baseSrcPath);
    }

    public HTMLReport(String projectName) {
        this(projectName, System.out, "");
    }

    @Override
    public final void add(ReportElement element) {
        QAInfo info = element.getQAInfo();
        if (info == null && ReportElement.ElementType.ERROR != element.getType()) {
            return;
        }
        if (ReportElement.ElementType.ERROR == element.getType()) {
            this.errorElements.add(this.formatErrorElement(element));
            return;
        }
        String filePath = element.getFilename();
        String headerInfo = "";
        String otherInfo = "";
        if (!this.initialized) {
            this.initialize();
        }
        if (QAInfo.Level.NOT_NEEDED == info.level() || QAInfo.State.QA_OK == info.state()) {
            return;
        }
        if (info.reviewers().length > 0) {
            headerInfo = headerInfo + " <b>Reviewers:</b> " + Arrays.toString(info.reviewers()) + " ";
        }
        if (!"".equals(info.author())) {
            headerInfo = headerInfo + " <b>Author:</b> " + info.author() + " ";
        }
        if (!"".equals(info.comment())) {
            otherInfo = otherInfo + "<b>Comment</b>: " + info.comment() + "<br/>";
        }
        if (!"".equals(info.deadline())) {
            otherInfo = otherInfo + "<b>Deadline</b>: " + info.deadline() + "<br/>";
        }
        if (!"".equals(info.revision())) {
            otherInfo = otherInfo + "<b>Revision</b>: " + info.revision() + "<br/>";
        }
        if (this.baseSrcPath.startsWith("http://")) {
            String baseDir;
            int dirSepIndex;
            String fileUrl = this.baseSrcPath.contains("@FILE@") ? this.baseSrcPath.replace("@FILE@", filePath) : this.baseSrcPath + filePath;
            if (fileUrl.contains("@MODULE@") && (dirSepIndex = (baseDir = element.getBaseDir()).indexOf(File.separator)) != -1) {
                fileUrl = fileUrl.replace("@MODULE@", baseDir.substring(0, dirSepIndex));
            }
            filePath = "<a href=\"" + fileUrl + "\">" + filePath + "</a>";
        }
        if ("".equals(headerInfo)) {
            headerInfo = "&nbsp;";
        }
        if ("".equals(otherInfo)) {
            otherInfo = "&nbsp;";
        }
        String s = ELEMENT_TEMPLATE.replace("@ELEMENT_NAME_ESCAPE@", element.getName());
        s = s.replace("@HEADER_INFO_ESCAPE@", headerInfo);
        s = s.replace("@OTHER_INFO_ESCAPE@", otherInfo);
        s = s.replace("@QA_LEVEL_ESCAPE@", info.level().toString());
        s = s.replace("@QA_STATE_ESCAPE@", info.state().toString());
        s = s.replace("@FILE_ESCAPE@", "<b>File</b>: " + filePath);
        s = s.replace("@ELEMENT_TYPE_ESCAPE@", element.getType().toString());
        if (QAInfo.State.UNDEFINED == info.state() || QAInfo.Level.UNDEFINED == info.level()) {
            this.undefinedElements.add(s);
        } else if (QAInfo.State.IN_DEVELOPMENT != info.state()) {
            this.out.println(s);
        } else {
            this.develElements.add(s);
        }
    }

    private String formatErrorElement(ReportElement element) {
        String s = ELEMENT_TEMPLATE.replace("@ELEMENT_NAME_ESCAPE@", element.getName());
        s = s.replace("@HEADER_INFO_ESCAPE@", "in " + element.getBaseDir() + " file: <b>" + element.getFilename() + "</b>");
        s = s.replace("@OTHER_INFO_ESCAPE@", "<code>" + element.getData().replace("\n", "<br/>") + "</code>");
        s = s.replace("@QA_LEVEL_ESCAPE@", "ERROR");
        s = s.replace("@QA_STATE_ESCAPE@", "<i>None</i>");
        s = s.replace("@FILE_ESCAPE@", "<b>File</b>: " + element.getFilename());
        s = s.replace("@ELEMENT_TYPE_ESCAPE@", "ERROR");
        return s;
    }

    @Override
    public void end() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.develElements.size() > 0) {
            this.out.println("<h2>In Development</h2>");
            for (String s : this.develElements) {
                this.out.println(s);
            }
        }
        if (this.undefinedElements.size() > 0) {
            this.out.println("<h2>Undefined QA State or Level</h2>");
            for (String s : this.undefinedElements) {
                this.out.println(s);
            }
        }
        if (this.errorElements.size() > 0) {
            this.out.println("<h2>Errors</h2>");
            for (String s : this.errorElements) {
                this.out.println(s);
            }
        }
        this.out.println(FOOTER_TEMPLATE);
        this.out.flush();
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = new PrintStream(out);
    }

    private void initialize() {
        String header = HEADER_TEMPLATE.replace("@TITLE_ESCAPE@", this.projectName);
        header = header.replace("@HEADER_ESCAPE@", this.projectName);
        header = header.replace("@STYLE_ESCAPE@", DEFAULT_STYLE_ESCAPE);
        header = header.replace("@DATE_ESCAPE@", new Date().toString());
        this.out.print(header);
        this.out.flush();
        this.initialized = true;
    }
}

