/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.reader;

import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.reader.CircularCharBuffer;
import dk.statsbiblioteket.util.reader.ReplaceReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.NoSuchElementException;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te")
public class CharArrayReplacer
extends ReplaceReader {
    private char[][] rules;
    private ThreadLocal bufferPool = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new CircularCharBuffer(10, Integer.MAX_VALUE);
        }
    };
    private CircularCharBuffer outBuffer = new CircularCharBuffer(10, Integer.MAX_VALUE);

    public CharArrayReplacer(Reader in, Map<String, String> rules) {
        super(in);
        this.rules = new char[65535][];
        for (char c = '\u0000'; c < '\uffff'; c = (char)((char)(c + 1))) {
            this.rules[c] = new char[]{c};
        }
        for (Map.Entry<String, String> entry : rules.entrySet()) {
            char[] target = entry.getKey().toCharArray();
            char[] destination = entry.getValue().toCharArray();
            if (target.length != 1) {
                throw new IllegalArgumentException(String.format("The rule '" + entry.getKey() + "' => " + entry.getValue() + "' was not single char to char array", new Object[0]));
            }
            this.rules[target[0]] = destination;
        }
    }

    public CharArrayReplacer(Map<String, String> rules) {
        this(new StringReader(""), rules);
    }

    private CharArrayReplacer(char[][] rules) {
        super(null);
        this.rules = rules;
    }

    @Override
    public Object clone() {
        return new CharArrayReplacer(this.rules);
    }

    @Override
    public char[] transformToChars(char c) {
        return this.rules[c];
    }

    @Override
    public char[] transformToChars(char[] chars) {
        CircularCharBuffer out = (CircularCharBuffer)this.bufferPool.get();
        out.clear();
        for (char c : chars) {
            out.put(this.rules[c]);
        }
        return out.takeAll();
    }

    @Override
    public char[] transformToCharsAllowInplace(char[] chars) {
        return this.transformToChars(chars);
    }

    @Override
    public String transform(String s) {
        StringWriter out = new StringWriter(s.length() * 4);
        for (int i = 0; i < s.length(); ++i) {
            for (char c : this.rules[s.charAt(i)]) {
                out.append(c);
            }
        }
        return out.toString();
    }

    @Override
    public ReplaceReader setSource(Reader reader) {
        this.in = reader;
        this.sourceBuffer = null;
        return this;
    }

    @Override
    public ReplaceReader setSource(CircularCharBuffer charBuffer) {
        this.sourceBuffer = charBuffer;
        this.in = null;
        return this;
    }

    @Override
    public synchronized int read() throws IOException {
        this.fillOutBuffer(1);
        try {
            return this.outBuffer.take();
        }
        catch (NoSuchElementException e) {
            return -1;
        }
    }

    private void fillOutBuffer(int min) throws IOException {
        try {
            if (this.in != null) {
                int codePoint = -1;
                while (this.outBuffer.size() < min && (codePoint = this.in.read()) != -1) {
                    this.outBuffer.put(this.rules[codePoint]);
                }
                return;
            }
            if (this.sourceBuffer != null) {
                while (this.outBuffer.size() < min) {
                    this.outBuffer.put(this.rules[this.sourceBuffer.take()]);
                }
                return;
            }
            throw new IllegalStateException("Neither sourceReader nor sourceBuffer has been set as source");
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    @Override
    public int read(CircularCharBuffer cbuf, int length) throws IOException {
        this.fillOutBuffer(length);
        return this.outBuffer.read(cbuf, length);
    }

    @Override
    public int read(char[] cbuf, int off, int length) throws IOException {
        this.fillOutBuffer(length);
        return this.outBuffer.read(cbuf, off, length);
    }
}

