/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.reader;

import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.reader.CharArrayReplacer;
import dk.statsbiblioteket.util.reader.CharReplacer;
import dk.statsbiblioteket.util.reader.ReplaceReader;
import dk.statsbiblioteket.util.reader.StringReplacer;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te")
public class ReplaceFactory {
    private ReplaceReader replacer;

    public ReplaceFactory(Map<String, String> rules) {
        this.replacer = ReplaceFactory.getReplacer(rules);
    }

    public ReplaceReader getReplacer() {
        return (ReplaceReader)this.replacer.clone();
    }

    public ReplaceReader getReplacer(Reader in) {
        ReplaceReader reader = this.getReplacer();
        reader.setSource(in);
        return reader;
    }

    public static ReplaceReader getReplacer(Reader in, Map<String, String> rules) {
        boolean allTargetsSingleChars = true;
        boolean allReplacementsSingleChars = true;
        for (Map.Entry<String, String> entry : rules.entrySet()) {
            allTargetsSingleChars &= entry.getKey().length() == 1;
            allReplacementsSingleChars &= entry.getValue().length() == 1;
        }
        if (allTargetsSingleChars && allReplacementsSingleChars) {
            return new CharReplacer(in, rules);
        }
        if (allTargetsSingleChars) {
            return new CharArrayReplacer(in, rules);
        }
        return new StringReplacer(in, rules);
    }

    public static ReplaceReader getReplacer(Map<String, String> rules) {
        return ReplaceFactory.getReplacer((Reader)new StringReader(""), rules);
    }

    public static ReplaceReader getReplacer(Reader in, String ... rules) {
        if (rules.length % 2 != 0) {
            throw new IllegalArgumentException("Uneven number of arguments");
        }
        HashMap<String, String> ruleMap = new HashMap<String, String>(rules.length, 1.0f);
        for (int i = 0; i < rules.length - 1; ++i) {
            ruleMap.put(rules[i], rules[++i]);
        }
        return ReplaceFactory.getReplacer(in, ruleMap);
    }

    public static ReplaceReader getReplacer(String ... rules) {
        return ReplaceFactory.getReplacer((Reader)new StringReader(""), rules);
    }
}

