/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.rpc;

import dk.statsbiblioteket.util.rpc.ConnectionFactory;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMIConnectionFactory<E extends Remote>
extends ConnectionFactory<E> {
    private Log log = LogFactory.getLog(RMIConnectionFactory.class);

    @Override
    public E createConnection(String connectionId) {
        int retries = 0;
        Exception lastError = null;
        for (retries = 0; retries < this.connectionRetries; ++retries) {
            this.log.debug("Looking up '" + connectionId + "'");
            try {
                return (E)Naming.lookup(connectionId);
            }
            catch (MalformedURLException e) {
                lastError = e;
            }
            catch (NotBoundException e) {
                lastError = e;
            }
            catch (RemoteException e) {
                lastError = e;
            }
            try {
                Thread.sleep(this.graceTime * 1000);
                continue;
            }
            catch (InterruptedException e) {
                this.log.error("Interrupted. Aborting connection creation.");
                break;
            }
        }
        this.log.error("Failed to look up service on '" + connectionId + "'. " + "Last error was:", lastError);
        return null;
    }
}

