/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.watch;

import dk.statsbiblioteket.util.Logs;
import dk.statsbiblioteket.util.qa.QAInfo;
import java.io.File;
import java.util.List;

@QAInfo(state=QAInfo.State.QA_NEEDED, level=QAInfo.Level.NORMAL, author="te")
public class FolderEvent {
    private File watchedFolder;
    private List<File> changeList;
    private EventType eventType;

    public FolderEvent(File watchedFolder, List<File> changeList, EventType eventType) {
        this.watchedFolder = watchedFolder;
        this.changeList = changeList;
        this.eventType = eventType;
    }

    public File getWatchedFolder() {
        return this.watchedFolder;
    }

    public List<File> getChangeList() {
        return this.changeList;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String toString() {
        switch (this.eventType) {
            case added: 
            case removed: {
                return (Object)((Object)this.eventType) + " " + Logs.expand(this.changeList, 10);
            }
            case watchedRemoved: {
                return "removed '" + this.watchedFolder + "'";
            }
            case watchedCreated: {
                return "created '" + this.watchedFolder + "' " + Logs.expand(this.changeList, 10);
            }
        }
        throw new IllegalArgumentException("The event type " + (Object)((Object)this.eventType) + " is unknown");
    }

    public static enum EventType {
        added,
        removed,
        watchedRemoved,
        watchedCreated;

    }
}

