/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.xml;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class DefaultNamespaceContext
implements NamespaceContext {
    private Map<String, Collection<String>> namespace = new HashMap<String, Collection<String>>();
    private Map<String, String> prefixes = new HashMap<String, String>();
    private String defaultNamespaceURI;

    public DefaultNamespaceContext() {
        this(null);
    }

    public DefaultNamespaceContext(String defaultNamespaceURI) {
        this.defaultNamespaceURI = defaultNamespaceURI;
        this.namespace.put("http://www.w3.org/2000/xmlns/", Arrays.asList("xmlns"));
        this.prefixes.put("xmlns", "http://www.w3.org/2000/xmlns/");
        this.namespace.put("http://www.w3.org/XML/1998/namespace", Arrays.asList("xml"));
        this.prefixes.put("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public DefaultNamespaceContext(String defaultNamespaceURI, String ... nsContext) {
        this(defaultNamespaceURI);
        if (nsContext.length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of arguments. Prefix/URI pairs must match up");
        }
        for (int i = 0; i < nsContext.length; i += 2) {
            this.setNameSpace(nsContext[i + 1], nsContext[i]);
        }
    }

    public void setNameSpace(String namespaceURL, String prefix) throws IllegalArgumentException {
        Collection<String> s = this.namespace.get(namespaceURL);
        if (s == null) {
            s = new HashSet<String>();
        }
        s.add(prefix);
        this.namespace.put(namespaceURL, s);
        this.prefixes.put(prefix, namespaceURL);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (prefix.equals("") && this.defaultNamespaceURI != null) {
            return this.defaultNamespaceURI;
        }
        if (!this.prefixes.containsKey(prefix)) {
            return "";
        }
        return this.prefixes.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        if (namespaceURI.equals(this.defaultNamespaceURI)) {
            return "";
        }
        Collection<String> s = this.namespace.get(namespaceURI);
        if (s != null && !s.isEmpty()) {
            return s.iterator().next();
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return new NonModifiableIterator(Arrays.asList("xml").iterator());
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return new NonModifiableIterator(Arrays.asList("xmlns").iterator());
        }
        if (namespaceURI.equals(this.defaultNamespaceURI)) {
            return new NonModifiableIterator(Arrays.asList("").iterator());
        }
        Collection<String> s = this.namespace.get(namespaceURI);
        if (s != null && !this.namespace.isEmpty()) {
            return new NonModifiableIterator(s.iterator());
        }
        return new NonModifiableIterator(new HashSet().iterator());
    }

    static class NonModifiableIterator
    implements Iterator {
        Iterator wrapped;

        NonModifiableIterator(Iterator iter) {
            this.wrapped = iter;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        public Object next() {
            return this.wrapped.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Conform to XML API please");
        }
    }
}

