/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.xml;

import dk.statsbiblioteket.util.Strings;
import dk.statsbiblioteket.util.qa.QAInfo;
import dk.statsbiblioteket.util.reader.CharSequenceReader;
import dk.statsbiblioteket.util.reader.CircularCharBuffer;
import dk.statsbiblioteket.util.reader.ReplaceReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@QAInfo(level=QAInfo.Level.NORMAL, state=QAInfo.State.IN_DEVELOPMENT, author="te")
public class NamespaceRemover
extends ReplaceReader {
    private Mode mode = Mode.PLAIN;
    private CircularCharBuffer inBuf = new CircularCharBuffer(100, Integer.MAX_VALUE);
    private CircularCharBuffer outBuf = new CircularCharBuffer(100, Integer.MAX_VALUE);
    private final Matcher declarationMatcher = Pattern.compile("xmlns(\\:.+)? *\\= *\".*\"").matcher("");
    private final Matcher defaultDeclarationMatcher = Pattern.compile("xmlns *\\= *\".*\"").matcher("");
    private final Matcher prefixMatcher = Pattern.compile("[a-zA-Z_\\.\\-0-9]+\\:([a-zA-Z_\\.\\-0-9]+)").matcher("");
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";
    private static final String TAG_START = "<";
    private static final String TAG_END = ">";
    private static final int LONGEST = "<![CDATA[".length();

    public NamespaceRemover(Reader in) {
        super(in);
    }

    public String transform(CharSequence s) {
        CircularCharBuffer buf = new CircularCharBuffer(s.length(), Integer.MAX_VALUE);
        this.removeNamespace(s, buf);
        return buf.toString();
    }

    @Override
    public String transform(String s) {
        return this.transform((CharSequence)s);
    }

    @Override
    public char[] transformToChars(char c) {
        return new char[]{c};
    }

    @Override
    public char[] transformToChars(char[] chars) {
        CircularCharBuffer buf = new CircularCharBuffer(chars.length, Integer.MAX_VALUE);
        this.removeNamespace(Strings.asCharSequence(chars), buf);
        return buf.takeAll();
    }

    @Override
    public char[] transformToCharsAllowInplace(char[] chars) {
        return this.transformToChars(chars);
    }

    @Override
    public NamespaceRemover setSource(Reader in) {
        this.mode = Mode.PLAIN;
        this.inBuf.clear();
        this.outBuf.clear();
        this.in = in;
        return this;
    }

    @Override
    public NamespaceRemover setSource(CircularCharBuffer in) {
        this.mode = Mode.PLAIN;
        this.inBuf.clear();
        this.outBuf.clear();
        this.in = new CharSequenceReader(in);
        return this;
    }

    @Override
    public int read() throws IOException {
        this.ensureLength(1);
        return this.outBuf.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureLength(len);
        return this.outBuf.read(cbuf, off, len);
    }

    @Override
    public int read(CircularCharBuffer cbuf, int len) throws IOException {
        this.ensureLength(len);
        return this.outBuf.read(cbuf, len);
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        this.ensureLength(cbuf.length);
        return this.outBuf.read(cbuf, 0, cbuf.length);
    }

    @Override
    public boolean ready() throws IOException {
        return !this.outBuf.isEmpty() || this.in.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.ensureLength(100);
        return this.outBuf.read(target);
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new UnsupportedOperationException("No marking in NamespaceRemover");
    }

    @Override
    public long skip(long n) throws IOException {
        long counter = 0L;
        int i = 0;
        while ((long)i < n && this.read() != -1) {
            ++counter;
            ++i;
        }
        return counter;
    }

    @Override
    public void reset() throws IOException {
        this.outBuf.clear();
        this.in.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.outBuf.clear();
    }

    @Override
    public Object clone() {
        return new NamespaceRemover(null);
    }

    private void ensureLength(int length) throws IOException {
        block5: while (this.outBuf.size() < length) {
            this.ensureInLength(LONGEST);
            if (this.inBuf.isEmpty()) {
                return;
            }
            switch (this.mode) {
                case PLAIN: {
                    int i;
                    if (this.inStartsWith(CDATA_START)) {
                        this.mode = Mode.CDATA;
                        for (i = 0; i < CDATA_START.length(); ++i) {
                            this.outBuf.put((char)this.inBuf.read());
                        }
                        continue block5;
                    }
                    if (this.inStartsWith(COMMENT_START)) {
                        this.mode = Mode.COMMENT;
                        for (i = 0; i < COMMENT_START.length(); ++i) {
                            this.outBuf.put((char)this.inBuf.read());
                        }
                        continue block5;
                    }
                    if (this.inStartsWith(TAG_START)) {
                        this.handleTag();
                        continue block5;
                    }
                    this.outBuf.put((char)this.inBuf.read());
                    continue block5;
                }
                case CDATA: {
                    int i;
                    if (this.inStartsWith(CDATA_END)) {
                        this.mode = Mode.PLAIN;
                        for (i = 0; i < CDATA_END.length(); ++i) {
                            this.outBuf.put((char)this.inBuf.read());
                        }
                        continue block5;
                    }
                    this.outBuf.put((char)this.inBuf.read());
                    continue block5;
                }
                case COMMENT: {
                    int i;
                    if (this.inStartsWith(COMMENT_END)) {
                        this.mode = Mode.PLAIN;
                        for (i = 0; i < COMMENT_END.length(); ++i) {
                            this.outBuf.put((char)this.inBuf.read());
                        }
                        continue block5;
                    }
                    this.outBuf.put((char)this.inBuf.read());
                    continue block5;
                }
            }
            throw new IllegalStateException(String.format("Mode %s is unknown", new Object[]{this.mode}));
        }
    }

    private void handleTag() throws IOException {
        this.ensureInLength(2);
        if (this.inBuf.length() < 2 || this.inBuf.charAt(1) == '!' || !this.ensureEnd(TAG_END)) {
            this.outBuf.put((char)this.inBuf.read());
            return;
        }
        char[] cbuf = new char[this.inBuf.indexOf(TAG_END) + TAG_END.length()];
        this.inBuf.read(cbuf, 0, cbuf.length);
        this.removeNamespace(new String(cbuf), this.outBuf);
    }

    protected void removeNamespace(CharSequence tag, CircularCharBuffer out) {
        tag = this.declarationMatcher.reset(tag).replaceAll("");
        tag = this.defaultDeclarationMatcher.reset(tag).replaceAll("");
        int first = Strings.indexOf('\"', tag);
        int next = Strings.indexOf('\"', first + 1, tag);
        if (first != -1 && next > first) {
            out.put(this.prefixMatcher.reset(tag.subSequence(0, first)).replaceAll("$1"));
            out.put(tag.subSequence(first, next + 1));
            this.removeNamespace(tag.subSequence(next + 1, tag.length()), out);
        } else {
            out.put(this.prefixMatcher.reset(tag).replaceAll("$1"));
        }
    }

    private boolean ensureEnd(String endStr) throws IOException {
        int pos = 0;
        do {
            if (this.inBuf.indexOf(endStr, pos) != -1) {
                return true;
            }
            pos = this.inBuf.size();
        } while (this.ensureInLength(this.inBuf.size() * 2 + endStr.length()) != -1);
        return false;
    }

    private boolean inStartsWith(String match) {
        if (this.inBuf.size() < match.length()) {
            return false;
        }
        for (int i = 0; i < match.length(); ++i) {
            if (match.charAt(i) == this.inBuf.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private int ensureInLength(int length) throws IOException {
        int count = 0;
        while (this.inBuf.size() < length) {
            int next = this.in.read();
            if (next == -1) {
                return count == 0 ? -1 : count;
            }
            this.inBuf.put((char)next);
            ++count;
        }
        return count;
    }

    private static enum Mode {
        PLAIN,
        CDATA,
        COMMENT;

    }
}

