/*
 * Decompiled with CFR 0.152.
 */
package dk.statsbiblioteket.util.xml;

import dk.statsbiblioteket.util.xml.LRUCache;
import dk.statsbiblioteket.util.xml.XPathSelectorImpl;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SynchronousXPathSelector
extends XPathSelectorImpl {
    private static final Log log = LogFactory.getLog(SynchronousXPathSelector.class);
    private static final XPath xpathCompiler = XPathFactory.newInstance().newXPath();
    private LRUCache<String, List<XPathExpression>> cache;
    private NamespaceContext nsContext;

    public SynchronousXPathSelector(NamespaceContext nsContext, int cacheSize) {
        super(nsContext, 1);
        this.cache = new LRUCache(cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object selectObject(Node dom, String xpath, QName returnType) {
        Object retval = null;
        try {
            XPathExpression exp;
            ArrayList<XPathExpression> expl;
            XPath xPath = xpathCompiler;
            synchronized (xPath) {
                expl = (List)this.cache.get(xpath);
                if (expl == null || expl.size() == 0) {
                    if (this.nsContext != null) {
                        xpathCompiler.setNamespaceContext(this.nsContext);
                    }
                    exp = xpathCompiler.compile(xpath);
                } else {
                    exp = (XPathExpression)expl.remove(expl.size() - 1);
                }
            }
            try {
                Document doc = dom.getOwnerDocument();
                if (doc != null) {
                    expl = doc;
                    synchronized (expl) {
                        retval = exp.evaluate(dom, returnType);
                    }
                }
                expl = dom;
                synchronized (expl) {
                    retval = exp.evaluate(dom, returnType);
                }
                xPath = xpathCompiler;
            }
            catch (Throwable throwable) {
                XPath xPath2 = xpathCompiler;
                synchronized (xPath2) {
                    ArrayList<XPathExpression> expl2 = (ArrayList<XPathExpression>)this.cache.get(xpath);
                    if (expl2 == null) {
                        expl2 = new ArrayList<XPathExpression>(2);
                    }
                    expl2.add(exp);
                    this.cache.put(xpath, expl2);
                }
                throw throwable;
            }
            synchronized (xPath) {
                expl = (List)this.cache.get(xpath);
                if (expl == null) {
                    expl = new ArrayList<XPathExpression>(2);
                }
                expl.add(exp);
                this.cache.put(xpath, expl);
            }
        }
        catch (NullPointerException e) {
            log.debug(String.format("NullPointerException when extracting XPath '%s' on element type %s. Returning null", xpath, returnType.getLocalPart()), e);
        }
        catch (XPathExpressionException e) {
            log.warn(String.format("Error in XPath expression '%s' when selecting %s: %s", xpath, returnType.getLocalPart(), e.getMessage()), e);
        }
        return retval;
    }

    @Override
    void clearCache() {
        this.cache.clear();
    }
}

